/*
 * Decompiled with CFR 0.152.
 */
package paulevs.betternether.world;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import net.minecraft.class_1936;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_5425;
import paulevs.betternether.config.Configs;
import paulevs.betternether.noise.OpenSimplexNoise;
import paulevs.betternether.registry.NetherBlocks;
import paulevs.betternether.world.structures.IStructure;
import paulevs.betternether.world.structures.StructureGeneratorThreadContext;
import paulevs.betternether.world.structures.StructureType;
import paulevs.betternether.world.structures.StructureWorld;
import paulevs.betternether.world.structures.decorations.StructureStalactiteCeil;
import paulevs.betternether.world.structures.decorations.StructureStalactiteFloor;
import paulevs.betternether.world.structures.plants.StructureWartCap;
import ru.bclib.world.biomes.BCLBiome;
import ru.bclib.world.biomes.BCLBiomeSettings;

public abstract class NetherBiome
extends BCLBiome {
    private static final String[] DEF_STRUCTURES = new String[]{NetherBiome.structureFormat("altar_01", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_02", -4, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_03", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_04", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_05", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_06", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_07", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("altar_08", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("portal_01", -4, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("portal_02", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("garden_01", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("garden_02", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_01", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_02", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_03", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_04", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_05", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("pillar_06", -1, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_01", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_02", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_03", -3, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("respawn_point_04", -2, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("spawn_altar_ladder", -5, StructureType.FLOOR, 1.0f), NetherBiome.structureFormat("ghast_hive", -20, StructureType.CEIL, 1.0f), NetherBiome.structureFormat("lava/pyramid_1", -1, StructureType.LAVA, 1.0f), NetherBiome.structureFormat("lava/pyramid_2", -1, StructureType.LAVA, 1.0f), NetherBiome.structureFormat("lava/pyramid_3", -1, StructureType.LAVA, 1.0f), NetherBiome.structureFormat("lava/pyramid_4", -1, StructureType.LAVA, 1.0f)};
    protected static final StructureStalactiteFloor STALACTITE_NETHERRACK = new StructureStalactiteFloor(NetherBlocks.NETHERRACK_STALACTITE, null);
    protected static final StructureStalactiteFloor STALACTITE_GLOWSTONE = new StructureStalactiteFloor(NetherBlocks.GLOWSTONE_STALACTITE, class_2246.field_10171);
    protected static final StructureStalactiteFloor STALACTITE_BLACKSTONE = new StructureStalactiteFloor(NetherBlocks.BLACKSTONE_STALACTITE, class_2246.field_23869, class_2246.field_23869, class_2246.field_10515);
    protected static final StructureStalactiteFloor STALACTITE_BASALT = new StructureStalactiteFloor(NetherBlocks.BASALT_STALACTITE, class_2246.field_22091, class_2246.field_22091, class_2246.field_10515);
    protected static final StructureStalactiteCeil STALAGMITE_NETHERRACK = new StructureStalactiteCeil(NetherBlocks.NETHERRACK_STALACTITE, null);
    protected static final StructureStalactiteCeil STALAGMITE_GLOWSTONE = new StructureStalactiteCeil(NetherBlocks.GLOWSTONE_STALACTITE, class_2246.field_10171);
    protected static final StructureStalactiteCeil STALAGMITE_BLACKSTONE = new StructureStalactiteCeil(NetherBlocks.BLACKSTONE_STALACTITE, class_2246.field_23869, class_2246.field_23869, class_2246.field_10515);
    protected static final StructureStalactiteCeil STALAGMITE_BASALT = new StructureStalactiteCeil(NetherBlocks.BASALT_STALACTITE, class_2246.field_22091, class_2246.field_22091, class_2246.field_10515);
    private static final OpenSimplexNoise SCATTER = new OpenSimplexNoise(1337L);
    private static int structureID = 0;
    private final ArrayList<StructureInfo> generatorsFloor = new ArrayList();
    private final ArrayList<StructureInfo> generatorsWall = new ArrayList();
    private final ArrayList<StructureInfo> generatorsCeil = new ArrayList();
    private final ArrayList<StructureInfo> generatorsLava = new ArrayList();
    private final ArrayList<StructureInfo> buildGeneratorsFloor = new ArrayList();
    private final ArrayList<StructureInfo> buildGeneratorsCeil = new ArrayList();
    private final ArrayList<StructureInfo> buildGeneratorsLava = new ArrayList();
    private final ArrayList<StructureInfo> buildGeneratorsUnder = new ArrayList();
    protected float plantDensity = 1.0001f;
    protected float noiseDensity = 0.3f;
    private final ArrayList<String> structures = new ArrayList(DEF_STRUCTURES.length);

    protected NetherBiome(class_2960 biomeID, class_1959 biome, BCLBiomeSettings settings) {
        super(biomeID, biome, settings);
        this.addStructure("cap_gen", new StructureWartCap(), StructureType.WALL, 0.8f, true);
        if (this.hasBNStructures()) {
            Collections.addAll(this.structures, DEF_STRUCTURES);
        }
        if (this.hasStalactites()) {
            this.addStructure("netherrack_stalactite", STALACTITE_NETHERRACK, StructureType.FLOOR, 0.05f, true);
            this.addStructure("glowstone_stalactite", STALACTITE_GLOWSTONE, StructureType.FLOOR, 0.01f, true);
            this.addStructure("netherrack_stalagmite", STALAGMITE_NETHERRACK, StructureType.CEIL, 0.01f, true);
            this.addStructure("glowstone_stalagmite", STALAGMITE_GLOWSTONE, StructureType.CEIL, 0.005f, true);
        }
        this.onInit();
        String structureGroup = this.configGroup() + ".structures";
        List structAll = Configs.BIOMES.getStringArray(structureGroup, "schematics", this.structures);
        for (String struct : structAll) {
            this.structureFromString(struct);
        }
        String group = this.configGroup();
        this.setPlantDensity(Configs.BIOMES.getFloat(group, "plants_and_structures_density", this.getPlantDensity()));
        this.setNoiseDensity(Configs.BIOMES.getFloat(group, "noise_density", this.getNoiseDensity()));
    }

    protected abstract void onInit();

    public boolean hasBNStructures() {
        return true;
    }

    public boolean hasStalactites() {
        return true;
    }

    public void setPlantDensity(float density) {
        this.plantDensity = density * 1.0001f;
    }

    public float getPlantDensity() {
        return this.plantDensity;
    }

    public void setNoiseDensity(float density) {
        this.noiseDensity = 1.0f - density * 2.0f;
    }

    public float getNoiseDensity() {
        return (1.0f - this.noiseDensity) / 2.0f;
    }

    public void genSurfColumn(class_1936 world, class_2338 pos, Random random) {
    }

    public void genFloorObjects(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (StructureInfo info : this.generatorsFloor) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random, MAX_HEIGHT, context);
        }
    }

    public void genWallObjects(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (StructureInfo info : this.generatorsWall) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random, MAX_HEIGHT, context);
        }
    }

    public void genCeilObjects(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (StructureInfo info : this.generatorsCeil) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random, MAX_HEIGHT, context);
        }
    }

    public void genLavaObjects(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        for (StructureInfo info : this.generatorsLava) {
            if (!info.canGenerate(random, pos)) continue;
            info.structure.generate(world, pos, random, MAX_HEIGHT, context);
        }
    }

    protected static double getFeatureNoise(class_2338 pos, int id) {
        return SCATTER.eval((double)pos.method_10263() * 0.1, (double)pos.method_10264() * 0.1 + (double)(id * 10), (double)pos.method_10260() * 0.1);
    }

    protected void addStructure(String name, IStructure structure, StructureType type, float density, boolean useNoise) {
        String group = this.configGroup() + ".structures." + type.getName() + "." + name;
        float dens = Configs.BIOMES.getFloat(group, "density", density);
        boolean limit = Configs.BIOMES.getBoolean(group, "limit", useNoise);
        this.addStructure(structure, type, dens, limit);
    }

    private void addStructure(IStructure structure, StructureType type, float density, boolean useNoise) {
        switch (type) {
            case CEIL: {
                this.generatorsCeil.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case FLOOR: {
                this.generatorsFloor.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case WALL: {
                this.generatorsWall.add(new StructureInfo(structure, density, useNoise));
                break;
            }
            case LAVA: {
                this.generatorsLava.add(new StructureInfo(structure, density, useNoise));
                break;
            }
        }
    }

    protected void addStructures(String ... structures) {
        this.structures.addAll(Arrays.asList(structures));
    }

    protected static String structureFormat(String name, int offset, StructureType type, float chance) {
        return String.format(Locale.ROOT, "name: %s; offset: %d; type: %s; chance: %f", name, offset, type.getName(), Float.valueOf(chance));
    }

    public void genFloorBuildings(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        this.chancedStructure(world, pos, random, MAX_HEIGHT, context, this.buildGeneratorsFloor);
    }

    public void genCeilBuildings(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        this.chancedStructure(world, pos, random, MAX_HEIGHT, context, this.buildGeneratorsCeil);
    }

    public void genLavaBuildings(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        this.chancedStructure(world, pos, random, MAX_HEIGHT, context, this.buildGeneratorsLava);
    }

    public void genUnderBuildings(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context) {
        this.chancedStructure(world, pos, random, MAX_HEIGHT, context, this.buildGeneratorsUnder);
    }

    private void chancedStructure(class_5425 world, class_2338 pos, Random random, int MAX_HEIGHT, StructureGeneratorThreadContext context, List<StructureInfo> infoList) {
        float chance = this.getLastChance(infoList);
        if (chance > 0.0f) {
            float rnd = random.nextFloat() * chance;
            for (StructureInfo info : infoList) {
                if (!(rnd <= info.density)) continue;
                info.structure.generate(world, pos, random, MAX_HEIGHT, context);
                return;
            }
        }
    }

    private void structureFromString(String structureString) {
        StructureWorld structure;
        String[] args = structureString.split(";");
        String name = "";
        int offset = 0;
        StructureType type = StructureType.FLOOR;
        float chance = 0.0f;
        for (String a : args) {
            if (a.contains("name:")) {
                name = a.replace("name:", "").trim();
                continue;
            }
            if (a.contains("offset:")) {
                offset = Integer.parseInt(a.replace("offset:", "").trim());
                continue;
            }
            if (a.contains("type:")) {
                type = StructureType.fromString(a);
                continue;
            }
            if (!a.contains("chance:")) continue;
            chance = Float.parseFloat(a.replace("chance:", "").trim());
        }
        if (!name.isEmpty() && (structure = new StructureWorld(name, offset, type)).loaded()) {
            ArrayList<StructureInfo> infoList = null;
            switch (structure.getType()) {
                case CEIL: {
                    infoList = this.buildGeneratorsCeil;
                    break;
                }
                case FLOOR: {
                    infoList = this.buildGeneratorsFloor;
                    break;
                }
                case LAVA: {
                    infoList = this.buildGeneratorsLava;
                    break;
                }
                case UNDER: {
                    infoList = this.buildGeneratorsUnder;
                    break;
                }
            }
            StructureInfo info = new StructureInfo(structure, chance += this.getLastChance(infoList), false);
            infoList.add(info);
        }
    }

    private float getLastChance(List<StructureInfo> info) {
        int size = info.size();
        return size > 0 ? info.get((int)(size - 1)).density : 0.0f;
    }

    public boolean hasCeilStructures() {
        return !this.buildGeneratorsCeil.isEmpty();
    }

    protected class StructureInfo {
        final IStructure structure;
        final float density;
        final boolean useNoise;
        final int id;

        StructureInfo(IStructure structure, float density, boolean useNoise) {
            this.structure = structure;
            this.density = density;
            this.useNoise = useNoise;
            this.id = structureID++;
        }

        boolean canGenerate(Random random, class_2338 pos) {
            return (!this.useNoise || NetherBiome.getFeatureNoise(pos, this.id) > (double)NetherBiome.this.noiseDensity) && random.nextFloat() < this.density;
        }
    }
}

